#include "StdAfx.h"
#include "DialogoLV.h"
#include "resource.h"

DialogoLV::DialogoLV(void) {
}

DialogoLV::~DialogoLV(void) {
}

// Funcin que crea el dialogo, enlaza sus controles y rellena los datos del ListView
void DialogoLV::Crear(void) {

    Creando = true;
    DDialogo::Crear(IDD_DIALOG1, 100, 100);
    ButtonSalir.Asignar(this, IDC_BUTTON1);

    ListaImagenes16.Crear(16, 16);
    ListaImagenes16.AgregarIconoCSLID(CSIDL_DESKTOP);

    ListaImagenes32.Crear(64, 64);
    ListaImagenes32.AgregarIconoCSLID(CSIDL_DESKTOP);

    // ListView para enumerar los estilos
    ListaEstilos.Asignar(this, IDC_LISTAESTILOS);
    ListaEstilos.AgregarColumna(TEXT("Estilo"), 220);
    ListaEstilos.AgregarColumna(TEXT("Valor"), 100, DEnum_ListView_AlineacionTexto_Derecha);
    ListaEstilos.ActivarGrupos(true);
    ListaEstilos.AgregarGrupo(TEXT("Estilos"), 0);
    ListaEstilos.AgregarGrupo(TEXT("Estilos Extendidos"), 1);

    DListView_Estilos   LVEstilos;
    ListaEstilos.ObtenerEstilos(LVEstilos);
    DListView_EstilosEx LVEstilosEx(LVS_EX_CHECKBOXES | LVS_EX_DOUBLEBUFFER);
    ListaEstilos.AsignarEstilosEx(LVEstilosEx);
    UINT i;

    // Relleno el ListView con los estilos y valores
    DString TmpValor;
    for (i = 0; i < LVEstilos.TotalEstilos(); i++) {
        TmpValor = LVEstilos.Estilo(i)->Valor;
        ListaEstilos.AgregarItem(0, -1, 0, LVEstilos.Estilo(i)->Definicion(), TmpValor());
    }
    for (i = 0; i < LVEstilosEx.TotalEstilos(); i++) { 
        TmpValor = LVEstilos.Estilo(i)->Valor;
        ListaEstilos.AgregarItem(0, -1, 1, LVEstilosEx.Estilo(i)->Definicion(), TmpValor());
    }

    // ListView para probar los modos de edicin
    ListView.Asignar(this, IDC_LISTVIEW1);
    ListView.AgregarColumna(TEXT("Texto seleccionado"), 120, DEnum_ListView_AlineacionTexto_Izquierda, DEnum_ListView_TipoEdicion_ComboStatic);
    ListView.AgregarColumna(TEXT("Texto normal"), 120, DEnum_ListView_AlineacionTexto_Izquierda, DEnum_ListView_TipoEdicion_ComboStatic);
    ListView.AgregarColumna(TEXT("Edit Texto"), 100, DEnum_ListView_AlineacionTexto_Izquierda, DEnum_ListView_TipoEdicion_EditTexto);
    ListView.AgregarColumna(TEXT("Combo Texto"), 100, DEnum_ListView_AlineacionTexto_Izquierda, DEnum_ListView_TipoEdicion_ComboEditTexto);

    ListView.AsignarImageList(&ListaImagenes16, DEnum_ListView_ImageList_Peque);
    ListView.AsignarImageList(&ListaImagenes32, DEnum_ListView_ImageList_Normal);

    ListView.AgregarItem(0, -1, -1, TEXT("Negro"), TEXT("Negro"), TEXT("Editable1"), TEXT("Combo Editable"));
    ListView.AgregarItem(0, -1, -1, TEXT("Negro"), TEXT("Negro"), TEXT("Editable1"), TEXT("Combo Editable"));
    ListView.AgregarItem(0, -1, -1, TEXT("Negro"), TEXT("Negro"), TEXT("Editable1"), TEXT("Combo Editable"));
    ListView.AgregarItem(0, -1, -1, TEXT("Negro"), TEXT("Negro"), TEXT("Editable1"), TEXT("Combo Editable"));
    ListView.AgregarItem(0, -1, -1, TEXT("Negro"), TEXT("Negro"), TEXT("Editable1"), TEXT("Combo Editable"));


    ListView.MostrarSubItemsMosaico(3);

    // ComboBox para cambiar las vistas del ListView
    ComboVista.Asignar(this, IDC_COMBOVISTA);
    ComboVista.AgregarItem(TEXT("Detalles"));
    ComboVista.AgregarItem(TEXT("Iconos"));
    ComboVista.AgregarItem(TEXT("Lista"));
    ComboVista.AgregarItem(TEXT("Iconos pequeos"));
    ComboVista.AgregarItem(TEXT("Mosaico"));
    ComboVista.SeleccionarTexto(TEXT("Detalles"));

    ListView.AsignarEstilosEx(LVS_EX_FULLROWSELECT | LVS_EX_DOUBLEBUFFER | LVS_EX_COLUMNOVERFLOW);
    DetectarEstilosListView();

    Visible(true);
    Creando = false;

}

INT_PTR DialogoLV::Evento_ComboBox_CambioSeleccion(const UINT IDComboBox) {
    if (IDComboBox == IDC_COMBOVISTA) {
        DString Seleccion;
        ComboVista.ObtenerSeleccion(Seleccion);

        if (Seleccion == TEXT("Detalles"))          ListView.CambiarVista(DEnum_ListView_Vista_Detalles);
        if (Seleccion == TEXT("Iconos"))            ListView.CambiarVista(DEnum_ListView_Vista_Iconos);
        if (Seleccion == TEXT("Lista"))             ListView.CambiarVista(DEnum_ListView_Vista_Lista);
        if (Seleccion == TEXT("Iconos pequeos"))   ListView.CambiarVista(DEnum_ListView_Vista_IconosPeque);
        if (Seleccion == TEXT("Mosaico"))           ListView.CambiarVista(DEnum_ListView_Vista_Mosaico);

        DetectarEstilosListView();

    }
    return 0;
}

// Funcin que detecta los estilos del ListView, y los marca en ListaEstilos
void DialogoLV::DetectarEstilosListView(void) {
    UINT z, i;
    DString TxtItem;

    DListView_Estilos LVEstilos;
    ListView.ObtenerEstilos(LVEstilos);

    for (i = 0; i < ListaEstilos.TotalItems(); i++) {
        ListaEstilos.Item(i)->ObtenerTexto(0, TxtItem);
        for (z = 0; z < LVEstilos.TotalEstilos(); z++) {
            if (TxtItem == LVEstilos.Estilo(z)->Definicion()) {
                ListaEstilos.Item(i)->Marcar(LVEstilos.ObtenerEstiloPos(z));
                break;
            }
        }
    }

    DListView_EstilosEx LVEstilosEx;
    ListView.ObtenerEstilosEx(LVEstilosEx);

    for (i = 0; i < ListaEstilos.TotalItems(); i++) {
        ListaEstilos.Item(i)->ObtenerTexto(0, TxtItem);
        for (z = 0; z < LVEstilosEx.TotalEstilos(); z++) {
            if (TxtItem == LVEstilosEx.Estilo(z)->Definicion()) {
                ListaEstilos.Item(i)->Marcar(LVEstilosEx.ObtenerEstiloPos(z));
                break;
            }
        }
    }
}

// Funcin que detecta que estilos estan marcados en ListaEstilos, y los aplica al ListView.
void DialogoLV::AplicarEstilosListView(void) {
    UINT                i, z;
    DListView_Estilos   LVEstilos;
    DListView_EstilosEx LVEstilosEx;
    DString             TmpTxt;

    for (i = 0; i < ListaEstilos.TotalItems(); i++) {
        ListaEstilos.Item(i)->ObtenerTexto(0, TmpTxt);
        for (z = 0; z < LVEstilos.TotalEstilos(); z++) {
            if (ListaEstilos.Item(i)->Marcado() == TRUE) {
                if (TmpTxt == LVEstilos.Estilo(z)->Definicion()) {
                    LVEstilos.AsignarEstiloPos(z, TRUE);
                    break;
                }
            }
        }
        for (z = 0; z < LVEstilosEx.TotalEstilos(); z++) {
            if (ListaEstilos.Item(i)->Marcado() == TRUE) {
                if (TmpTxt == LVEstilosEx.Estilo(z)->Definicion()) {
                    LVEstilosEx.AsignarEstiloPos(z, TRUE);
                    break;
                }
            }
        }
    }

    ListView.AsignarEstilos(LVEstilos);
    ListView.AsignarEstilosEx(LVEstilosEx);
}

// Funcin que al cambiar un item aplica los estilos al ListView
// NOTA : hay que evitar que esta funcion aplique los estilos cuando se estan creando los items
INT_PTR DialogoLV::Evento_ListView_Item_Cambiado(const int nItem, const UINT IDListView) {
    if (Creando == true) return 0; // No hacer nada mientras se esta creando el dialogo
    if (IDListView == IDC_LISTAESTILOS) AplicarEstilosListView();
    return 0;
}

// Funcin que recibe cuando hacemos click en un boton
INT_PTR DialogoLV::Evento_Button_Mouse_Click(const UINT cID) {
    if (cID == IDC_BUTTON1) Destruir();
    return 0;
}


INT_PTR DialogoLV::Evento_ListView_Edicion_Empezar(DListView_DatosEdicion *DatosEdicion, const UINT IDListView) {
    if (IDListView != IDC_LISTVIEW1) return 0;
    switch (DatosEdicion->PosSubItem) {
        case 0: // Color texto seleccionado
        case 1: // Color texto normal
            DatosEdicion->Combo_AgregarItem(TEXT("Blanco"));
            DatosEdicion->Combo_AgregarItem(TEXT("Negro"));
            DatosEdicion->Combo_AgregarItem(TEXT("Rojo"));
            DatosEdicion->Combo_AgregarItem(TEXT("Amarillo"));
            DatosEdicion->Combo_AgregarItem(TEXT("Azul"));
            DatosEdicion->Combo_AgregarItem(TEXT("Verde"));
            break;
        case 3 : // ComboEdit
            DatosEdicion->Combo_AgregarItem(TEXT("Opcion1"));
            DatosEdicion->Combo_AgregarItem(TEXT("Opcion2"));
            DatosEdicion->Combo_AgregarItem(TEXT("Opcion3"));
            DatosEdicion->Combo_AgregarItem(TEXT("Opcion4"));
            break;
    }
    return 0;
}

INT_PTR DialogoLV::Evento_ListView_Edicion_Terminar(DListView_DatosEdicion *DatosEdicion, const UINT IDListView) {
    if (IDListView != IDC_LISTVIEW1) return 0;
    switch (DatosEdicion->PosSubItem) {
        case 0 : // color texto seleccionado
            switch(DatosEdicion->ComboStatic_ObtenerSeleccion()) {
                case 0 : // blanco
                    ListView.Item(DatosEdicion->PosItem)->ColorTextoSeleccionado(RGB(255, 255, 255));
                    break;
                case 1 : // negro
                    ListView.Item(DatosEdicion->PosItem)->ColorTextoSeleccionado(RGB(0, 0, 0));
                    break;
                case 2 : // rojo
                    ListView.Item(DatosEdicion->PosItem)->ColorTextoSeleccionado(RGB(255, 0, 0));
                    break;
                case 3 : // amarillo
                    ListView.Item(DatosEdicion->PosItem)->ColorTextoSeleccionado(RGB(255, 255, 0));
                    break;
                case 4 : // azul
                    ListView.Item(DatosEdicion->PosItem)->ColorTextoSeleccionado(RGB(0, 0, 255));
                    break;
                case 5 : // verde
                    ListView.Item(DatosEdicion->PosItem)->ColorTextoSeleccionado(RGB(0, 255, 0));
                    break;
            }
            break;
        case 1 : // color texto normal
            switch(DatosEdicion->ComboStatic_ObtenerSeleccion()) {
                case 0 : // blanco
                    ListView.Item(DatosEdicion->PosItem)->ColorTexto(RGB(255, 255, 255));
                    break;
                case 1 : // negro
                    ListView.Item(DatosEdicion->PosItem)->ColorTexto(RGB(0, 0, 0));
                    break;
                case 2 : // rojo
                    ListView.Item(DatosEdicion->PosItem)->ColorTexto(RGB(255, 0, 0));
                    break;
                case 3 : // amarillo
                    ListView.Item(DatosEdicion->PosItem)->ColorTexto(RGB(255, 255, 0));
                    break;
                case 4 : // azul
                    ListView.Item(DatosEdicion->PosItem)->ColorTexto(RGB(0, 0, 255));
                    break;
                case 5 : // verde
                    ListView.Item(DatosEdicion->PosItem)->ColorTexto(RGB(0, 255, 0));
                    break;
            }
            break;

    }
    return 0;
}
